/* Concurrent CP/M-86 System Calls */

					/* Auxiliary Device System Calls */
#define	A_ATTACH	165		/* Attach Default Auxiliary Device */
#define	A_CATTACH	167		/* Conditionally Attach Device */
#define	A_DETACH	166		/* Detach Default Auxiliary Device */
#define	A_GET		169		/* Get the Default Auxiliary Device */
#define	A_READ		  3		/* Get a Character from Aux Device */
#define	A_READBLK	172		/* Read a Block from Aux Device */
#define	A_SET		168		/* Set Default Aux Device */
#define	A_STATIN	  7		/* Aux Device Input Status */
#define	A_STATOUT	  8		/* Aux Device Output Status */
#define	A_WRITE		  4		/* Output a character to Aux Device */
#define	A_WRITEBLK	173		/* Write a Block to Aux Device */

					/* Console Based System Calls */
#define	C_ASSIGN   	149		/* Assign Default Console */
#define	C_ATTACH   	146		/* Attach Default Virtual Console */
#define	C_ATTRIB	114		/* Return Console Attributes */
#define	C_CATTACH  	162		/* Conditionally Attach Console */
#define	C_DELIMIT    	110		/* Default String Delimiter */
#define	C_DETACH	147		/* Detach Virtual Console */
#define	C_GET     	153		/* Get the Virtual Console Number */
#define	C_MODE       	109		/* Set the Console mode */
#define	C_RAWIO      	  6		/* Perform Direct I/O */
#define	C_READ       	  1		/* Read a character from the console */
#define	C_READSTR    	 10		/* Read a string from the console */
#define	C_SET     	148		/* Change the Default Console */
#define	C_STAT       	 11		/* Get the Input Status */
#define	C_WRITE      	  2		/* Write a character to the Console */
#define	C_WRITEBLK   	111		/* Write a block of characters */
#define	C_WRITESTR   	  9		/* Write a string */

					/* Device Based System Calls */
#define	DEV_POLL	131		/* poll device */
#define	DEV_FLAGALLOC	 87		/* allocate flag */
#define	DEV_FLAGFREE	 88		/* free system flag */
#define	DEV_WAITFLAG	132		/* flag wait */
#define	DEV_SETFLAG	133		/* flag set */

					/* Drive Management Functions */
#define	DRV_ACCESS   	 38		/* Access drive (in LOCK TBL) */
#define	DRV_ALLOCVEC 	 27		/* Get the Allocation Vector */
#define	DRV_ALLRESET 	 13		/* Reset all drives */
#define	DRV_DPB      	 31		/* Get the DPB */
#define	DRV_FLUSH    	 48		/* Flush internal buffers */
#define	DRV_FREE     	 39		/* Relinguish access to drive */
#define	DRV_GET      	 25		/* Get the default Drive */
#define	DRV_GETLABEL 	101		/* Get the drives label */
#define	DRV_LOCK	 90		/* lock physical drive */
#define	DRV_LOGINVEC 	 24		/* Get the login vector */
#define	DRV_RESET    	 37		/* Reset specified drives */
#define	DRV_ROVEC    	 29		/* Get Read Only drives */
#define	DRV_SET      	 14		/* Set the default drive */
#define	DRV_SETLABEL 	100		/* Set the drive label */
#define	DRV_SETRO    	 28		/* Set the default drive to Read Only */
#define	DRV_SPACE    	 46		/* Return the Unalloacted space */
#define	DRV_UNLOCK	 91		/* unlock physical drive */

					/* File Management Functions */
#define	F_ATTRIB     	 30		/* Set file attributes */
#define	F_CLOSE      	 16		/* Close File */
#define	F_DELETE    	 19		/* Delete File */
#define	F_DMAGET	 52		/* Return DMA address */
#define	F_DMAOFF       	 26		/* Set DMA Buffer Offset */
#define	F_DMASEG	 51		/* Set DMA Segment */
#define	F_DOS		113		/* Handle Functions */
#define	F_ERRMODE    	 45		/* Set BDOS error mode */
#define	F_LOCK       	 42		/* Lock Records in a File */
#define	F_MAKE       	 22		/* Create a file */
#define	F_MULTISEC   	 44		/* Set the Mutli sector I/O count */
#define	F_OPEN       	 15		/* Open a file */
#define	F_PARSE      	152		/* Initialize an FCB from string */
#define	F_PASSWD     	106		/* Set the default password */
#define	F_RANDREC    	 36		/* Set Random record */
#define	F_READ       	 20		/* Read Sequential */
#define	F_READRAND   	 33		/* Read Random */
#define	F_RENAME     	 23		/* Rename file */
#define	F_SETDATE	116		/* Set File Time and Date Stamp */
#define	F_SFIRST	 17		/* Get first Matching file */
#define	F_SIZE       	 35		/* Get file Size */
#define	F_SNEXT		 18		/* Get subsequent files */
#define	F_TIMEDATE   	102		/* Return date and time */
#define	F_TRUNCATE   	 99		/* Truncate the file */
#define	F_UNLOCK     	 43		/* Unlock File */
#define	F_USERNUM    	 32		/* Set or return user number */
#define	F_WRITE      	 21		/* Write Sequential */
#define	F_WRITERAND  	 34		/* Write Random */
#define	F_WRITEZF 	 40		/* Write with Zero fill */
#define	F_WRITEXFCB  	103		/* Create or update XFCB */

					/* Printer Related system calls */
#define	L_ATTACH   	158		/* Attach Default List device */
#define	L_CATTACH  	161		/* Conditionally Attach List Device */
#define	L_DETACH	159		/* Detach Virtual Printer */
#define	L_GET     	164		/* Get the Default Printer */
#define	L_SET     	160		/* Change the Default Printer */
#define	L_WRITE      	  5		/* Write a character to the Printer */
#define	L_WRITEBLK   	112		/* Write a block of characters */

					/* MP/M Memory Allocation */
#define	M_ALLOC      	128		/* Allocate Memory Segment */
#define	M_FREE       	130		/* Free Memory Segment */

					/* CP/M Memory Alloacation */
#define	MC_ABS       	 54		/*   */
#define	MC_ALLFREE   	 58		/*   */
#define	MC_ALLOC     	 55		/*   */
#define	MC_ALLOCABS  	 56		/*   */
#define	MC_FREE      	 57		/*   */
#define	MC_MAX       	 53		/*   */

					/* Network Function Calls */
#define	N_ATTACH         73		/* Attach Process to Network */
#define	N_ATTRIB	 70		/* Set Compatiblilty Attributes */
#define	N_DETACH	 74		/* Detach a process from the network */
#define	N_ERRMODE	 72		/* Set the Network Error Mode */
#define	N_LOGOFF	 65		/* Terminate Link with Server */
#define	N_LOGON		 64		/* Log a process to a server */
#define	N_LONGTIME	 76		/* Set the Long TimeOut Value */
#define	N_NAME		 78		/* Network Names Support */
#define	N_PARATAB	 77		/* Get the Parameter table */
#define	N_PASSWORD	 75		/* Set the Network Password */
#define	N_RCT		 69		/* Set Requester Config Table */
#define	N_SCT		 71		/* Get Server Config Table */
#define	N_STAT		 68		/* Get Network Status Word */
#define	N_XERROR	 79		/* Network Extended Errors */

					/* process control functions: */
#define	P_ABORT      	157		/* Terminate a Process */
#define	P_CHAIN      	 47		/* Chain to a process */
#define	P_CLI        	150		/* Interpret command line */
#define	P_CREATE     	144		/* Create a process */
#define	P_DELAY		141		/* delay specified number of ticks */
#define	P_DISPATCH	142		/* let other another process run */
#define	P_EXEC		 93		/* CDOS 6.0 Exec/Chain Function */
#define	P_EXITCODE	 94		/* CDOS 6.0 Get/Set Error Code */
#define	P_LOAD       	 59		/* Load the specified CMD file */
#define	P_PATH		 92		/* locate file in search path */
#define	P_PDADR		156		/* dbl word ptr of process descriptor */
#define	P_PRIORITY   	145		/* Set process priority */
#define	P_RPL        	151		/* Invoke a system call from RPL */
#define	P_TERM		143		/* Terminate process */
#define	P_TERMCPM 	  0		/* Terminate process Unconditionally */

					/* Queue Management Functions */
#define	Q_CREAD		138		/* Conditional Read */
#define	Q_CWRITE	140		/* Conditional Write */
#define	Q_DELETE	136		/* Queue Delete */
#define	Q_MAKE		134		/* Create a Queue */
#define	Q_OPEN		135		/* Open a Queue */
#define	Q_READ		137		/* Read from Queue */
#define	Q_WRITE		139		/* Write to Queue */

					/* System Based Calls */
#define	S_BDOSVER    	 12		/* BDOS version Number */
#define	S_BIOS       	 50		/* Call BIOS character I/O routine */
#define	S_GETCOUNTRY	 96		/* CDOS 6.0 Get Country Data */
#define	S_MEMORY	 89		/* allocate SYSDAT memory */
#define	S_OSVER      	163		/* Return type and version number */
#define	S_SCB		 49		/* CP/M PLUS and DOS PLUS only */
#define	S_SETCOUNTRY	 95		/* CDOS 6.0 Set the System Country */
#define	S_SERIAL     	107		/* Return the Serial Number */
#define	S_SYSDAT     	154		/* Return System data page address */

					/* Time System Calls */
#define	T_GET        	105		/* Get the system Time */
#define	T_GETTIME	 83		/* Get Binary System Time */
#define	T_GETDATE	 85		/* Get Binary System Date */
#define	T_SECONDS    	155		/* As above + seconds */
#define	T_SET        	104		/* Set the system Time */
#define	T_SETTIME	 84		/* Set Binary System Time */
#define	T_SETDATE	 86		/* Set Binary System Date */
